# REST Service Template

Welcome to the REST Service template. This was generated using the gradle-templates project with the `createResourceProject` task. The goal of this template is to provide the majority of the foundational elements required to get a backend service started. There are several things

Now that we have most of the boilerplate created, there are a few things that are purposely left out (passwords, specific URLs, etc.).

## Tomcat

If you're interested deploying your service Tomcat, the gradle file has a built in `deployWar` task. You will need to customize the `properties.xml` file with your tomcat administrator credentials under the included `ant-builds` directory.

After updating the configuration, run the following task:

    gradle deployWar

If you navigate to your services root directory, you'll receive a basic welcome page to validate that your service is running properly.

## WebLogic

Alternatively, you can use the `deployToWeblogic` task to deploy to a WebLogic server. By default it will attempt to deploy to the AdminServer but the credentials are not setup. You will need to

## Git

Your service is also configured with a default `.gitignore` for common Java files that should not be committed to the repository.

Your application has helpful configurations for git, but out of the box it is not "turned on". To do so, go through the following steps:

    # Initialize the git repository
    $ git init

    # Setup a remote origin
    $ git remote add origin {remote-location}

    # Push to origin, where {branch-name} is typically master
    $ git push -u origin {branch-name}

## Artifact Publishing and Versioning

Your service has publishing and versioning built in. By default, it will publish to a local directory called `local-publish`. If you would like to publish to artifactory or nexus, you will need to set the username/password in `gradle.properties` and the url in `build.gradle`.

To support publishing a unique version for every published artifact, the `getMetaVersion` method is provided. Once you have initialized your git repository, you will be able to

## Security

This service is also contains all of the Spring Security / Authorization Services support that you will need to ensure your resource endpoints are not exposing healthcare data without the precence of an auth token.

